//=============================================================================
// Arthran Verbose Error Screen
// Art_VerboseErrorScreen.js
//=============================================================================

var Imported = Imported || {};
Imported.Art_ShopResults = true;

var Arthran = Arthran || {};
Arthran.VerboseErrors = Arthran.VerboseErrors || {};
Arthran.VerboseErrors.version = 1.10;

/*:
* @target MZ
* @plugindesc [Version 1.10] Verbose Error Screen
* @author Arthran
* @url https://arthran2.itch.io/verbose-error-screen
*
* @param errorNameColor
* @text Error Name Color
* @desc The color of the error name.
* @type text
* @default #ffff00
*
* @param errorMessageColor
* @text Error Message Color
* @desc The color of the error message.
* @type text
* @default #ffffff
*
* @param errorStackColor
* @text Error Stack Color
* @desc The color of the error stack.
* @type text
* @default #ffffff
*
* @param buttonColor
* @text Button Color
* @desc The color of the copy button.
* @type text
* @default #000000
*
* @param buttonTextColor
* @text Button Text Color
* @desc The color of the copy button text.
* @type text
* @default #ffffff
*
* @param copyTooltipBackgroundColor
* @text Copy Tooltip Background Color
* @desc The background color of the copy tooltip.
* @type text
* @default #f7efd7
*
* @param copyTooltipTextColor
* @text Copy Tooltip Text Color
* @desc The text color of the copy tooltip.
* @type text
* @default #000000
*
* @help
*
* ------------------------------------------------------------------------
* Information
* ------------------------------------------------------------------------
* This plugin prints out more detailed error messages when an error occurs.
*
* ------------------------------------------------------------------------
* Terms of Use
* ------------------------------------------------------------------------
* Free for use in commercial and non-commercial projects. Credit is not
* required, but is appreciated. You may edit the plugin as you see fit, so 
* long as you do not claim ownership of the plugin.
*
* Copyright (c) 2023 Arthran
*/

Arthran.VerboseErrors.parameters = PluginManager.parameters('Art_VerboseErrorScreen');
Arthran.VerboseErrors.errorNameColor = Arthran.VerboseErrors.parameters['errorNameColor'].trim();
Arthran.VerboseErrors.errorMessageColor = Arthran.VerboseErrors.parameters['errorMessageColor'].trim();
Arthran.VerboseErrors.errorStackColor = Arthran.VerboseErrors.parameters['errorStackColor'].trim();
Arthran.VerboseErrors.buttonColor = Arthran.VerboseErrors.parameters['buttonColor'].trim();
Arthran.VerboseErrors.buttonTextColor = Arthran.VerboseErrors.parameters['buttonTextColor'].trim();
Arthran.VerboseErrors.copyTooltipBackgroundColor = Arthran.VerboseErrors.parameters['copyTooltipBackgroundColor'].trim();
Arthran.VerboseErrors.copyTooltipTextColor = Arthran.VerboseErrors.parameters['copyTooltipTextColor'].trim();

Arthran.VerboseErrors.Graphics_printError = Graphics.printError;
Graphics.printError = function(name, message, error = null) {
    Arthran.VerboseErrors.Graphics_printError.call(this, name, message, error);
    if (error) {
        this.showCopyButton(error);
    }
};

Graphics._makeErrorHtml = function(name, message, error) {
    const outerContainerDiv = document.createElement("div");
    const containerDiv = document.createElement("div");
    const topLineDiv = document.createElement("div");
    const nameDiv = document.createElement("div");
    const messageDiv = document.createElement("div");
    const stackDiv = document.createElement("div");

    outerContainerDiv.style.display = "flex";
    outerContainerDiv.style.justifyContent = "center";
    containerDiv.style.textAlign = "left";
    nameDiv.style.display = "inline-block";
    nameDiv.style.color = Arthran.VerboseErrors.errorNameColor || "#ffff00";
    messageDiv.style.display = "inline-block";
    messageDiv.style.marginLeft = "10px";
    messageDiv.style.color = Arthran.VerboseErrors.errorMessageColor || "#ffffff";
    messageDiv.style.fontWeight = "bold";
    stackDiv.style.marginLeft = "24px";
    stackDiv.style.color = Arthran.VerboseErrors.errorStackColor || "#ffffff";

    nameDiv.id = "errorName";
    messageDiv.id = "errorMessage";
    stackDiv.id = "errorStack";
    containerDiv.id = "errorContainer";
    
    nameDiv.innerHTML = Utils.escapeHtml(name || "");
    nameDiv.innerHTML = nameDiv.innerHTML === "" ? "" : nameDiv.innerHTML + ":";
    messageDiv.innerHTML = Utils.escapeHtml(message || "");
    stackDiv.innerHTML = Utils.formatErrorStackHtml(error?.stack || "");
    
    topLineDiv.appendChild(nameDiv);
    topLineDiv.appendChild(messageDiv);
    containerDiv.appendChild(topLineDiv);
    containerDiv.appendChild(stackDiv);
    outerContainerDiv.appendChild(containerDiv);

    return outerContainerDiv.outerHTML;
};

Graphics.showCopyButton = function(error) {
    const copyButton = document.createElement("button");

    copyButton.style.fontSize = "20px";
    copyButton.style.color = Arthran.VerboseErrors.buttonTextColor || "#ffffff";
    copyButton.style.backgroundColor = Arthran.VerboseErrors.buttonColor || "#000000";
    copyButton.style.borderRadius = "8px";
    copyButton.style.marginTop = "14px";
    copyButton.style.padding = "8px";

    copyButton.id = "copyButton";
    copyButton.innerHTML = "Copy to Clipboard";

    copyButton.ontouchstart = e => e.stopPropagation();
    copyButton.onclick = () => {
        Graphics._onCopyButtonClicked(error);
    };

    document.getElementById("errorContainer").appendChild(copyButton);
};

Graphics._updateErrorPrinter = function() {
    const width = this._width * 0.8 * this._realScale;
    this._errorPrinter.style.width = width + "px";
    this._errorPrinter.style.height = 'auto';
};

Graphics._onCopyButtonClicked = function(error) {
    const stackText = Utils.formatErrorStackText(error?.stack || "");
    navigator.clipboard.writeText(stackText).then(() => {
        const copyButton = document.getElementById("copyButton");
        const copyTooltip = document.createElement("div");
        const copyButtonRect = copyButton.getBoundingClientRect();
        copyTooltip.style.position = "fixed";
        copyTooltip.style.top = copyButtonRect.top - 40 + "px";
        copyTooltip.style.left = copyButtonRect.left + "px";
        copyTooltip.style.fontSize = "20px";
        copyTooltip.style.color = Arthran.VerboseErrors.copyTooltipTextColor || "#000000";
        copyTooltip.style.backgroundColor = Arthran.VerboseErrors.copyTooltipBackgroundColor || "#f7efd7";
        copyTooltip.style.opacity = "1.0";
        copyTooltip.style.borderRadius = "4px";
        copyTooltip.style.padding = "4px";
        copyTooltip.style.zIndex = "999";
        copyTooltip.innerHTML = "Copied!";
        document.body.appendChild(copyTooltip);
        setTimeout(() => {
            document.body.removeChild(copyTooltip);
        }, 1000);
    });
};

Utils.formatErrorStackHtml = function(stack) {
    if (stack !== "") {
        stack = stack.substring(stack.indexOf("\n") + 1);
        stack = stack.replaceAll(/chrome-extension:\/\/[^\r\n]*\/([^\r\n]+\.js:\d+):?\d*(?=\))/g, "$1");
        stack = this.escapeHtml(stack);
        stack = stack.replaceAll(/[\r\n][\r\n]?/g, "<br>");
    }
    return stack;
};

Utils.formatErrorStackText = function(stack) {
    if (stack !== "") {
        stack = stack.replaceAll(/chrome-extension:\/\/[^\r\n]*\/([^\r\n]+\.js:\d+):?\d*(?=\))/g, "$1");
        stack = stack.replaceAll(/([\r\n][\r\n]?)/g, "    $1");
    }
    return stack;
};